// Estilo general del body



// Agregar estilos con DOM cuando el contenido esté cargado
window.onload = function () {
    // Estilo para el body: centrar todo
    document.body.style.margin = "0";
    document.body.style.height = "100vh";
    document.body.style.display = "flex";
    document.body.style.justifyContent = "center";
    document.body.style.alignItems = "center";
    document.body.style.backgroundColor = "#fcf79f";
    document.body.style.fontFamily = "Calibri, sans-serif";

    // Estilo para el contenedor general
    const contenedor = document.getElementById("contenedor");
    contenedor.style.display = "flex";
    contenedor.style.flexDirection = "column";
    contenedor.style.alignItems = "center";
    contenedor.style.backgroundColor = "#ffffff";
    contenedor.style.padding = "30px";
    contenedor.style.borderRadius = "10px";
    contenedor.style.boxShadow = "0 0 15px rgba(0,0,0,0.1)";
    contenedor.style.maxWidth = "400px";
    contenedor.style.width = "90%";
    contenedor.style.boxSizing = "border-box";

   

    // Estilo para el formulario
    const formulario = document.getElementById("eje5");
    formulario.style.display = "flex";
    formulario.style.flexDirection = "column";
    formulario.style.alignItems = "center";
    formulario.style.width = "100%";
    formulario.style.padding = "20px";
    formulario.style.border = "2px solid #ccc";
    formulario.style.borderRadius = "10px";
    formulario.style.backgroundColor = "#f9f9f9";
    formulario.style.boxShadow = "0 0 10px rgba(0, 0, 0, 0.1)";
    formulario.style.boxSizing = "border-box";

    // Estilo para los labels
    const labels = formulario.getElementsByTagName("label");
    for (let label of labels) {
        label.style.marginTop = "10px";
        label.style.marginBottom = "5px";
        label.style.fontWeight = "bold";
        label.style.alignSelf = "flex-start";
    }

    // Estilo para los inputs
    const inputs = document.querySelectorAll("input");
    inputs.forEach(input => {
        input.style.width = "100%";
        input.style.padding = "8px";
        input.style.marginBottom = "10px";
        input.style.border = "1px solid #ccc";
        input.style.borderRadius = "4px";
        input.style.boxSizing = "border-box";
    });

    // Estilo para el botón
    const boton = document.getElementById("btnAceptar");
    boton.style.backgroundColor = "#ffbd33";
    boton.style.color = "#ffffff";
    boton.style.border = "none";
    boton.style.padding = "10px 20px";
    boton.style.fontSize = "16px";
    boton.style.borderRadius = "5px";
    boton.style.cursor = "pointer";
    boton.style.transition = "background-color 0.3s ease";
    boton.style.display = "block";
    boton.style.margin = "20px auto 10px auto";

    

    // Estilo para el mensaje <div>
    const mensaje = document.getElementById("mensaje");
    mensaje.style.textAlign = "center";
    mensaje.style.marginTop = "10px";
    mensaje.style.fontWeight = "bold";
    mensaje.style.width = "100%";
};

var letras = ['T', 'R', 'W', 'I', 'U', 'G', 'M', 'Y', 'F', 'P', 'D', 'X', 'B', 'N', 'J', 'Z', 'S', 'Q', 'V', 'H', 'L', 'C', 'K', 'E', 'A', 'O'];

// //En primer lugar (y en una sola instrucción) se debe comprobar si el número es menor que 0 o mayor que 25. Si ese es el caso, se muestra un mensaje al usuario indicando que el número proporcionado no es válido y el programa no muestra más mensajes.
function Controlar() {
    // Obtener los valores ingresados
   let NumeroIngresado = formulario5.numero.value
   let LetraIngresada = document.getElementById("letra").value.toUpperCase(); // Aqui lo convierto a mayúscula

  // Validar si el número NO está en el rango 0-25
   if (isNaN(NumeroIngresado) || NumeroIngresado < 0 || NumeroIngresado > 25) {
             mensaje.innerHTML = "<h2>El número proporcionado no es válido (debe estar entre 0 y 25)</h2>";
  }
   else {
    	
  	//Si el número es válido, se calcula la letra que le corresponde en el array.
    	
	
    let LetraCalculada = letras[NumeroIngresado];
    //alert("La letra calculada es: " + LetraCalculada);

	//Una vez calculada la letra, se debe comparar con la letra indicada por el usuario. Si no coinciden, se muestra un mensaje al usuario diciéndole que la letra que “Ha perdido”. En otro caso, se muestra un mensaje indicando que el número y la letra coinciden y que “Ha ganado”.	
	
   	if (LetraIngresada === LetraCalculada) {
  document.getElementById("mensaje").innerHTML =
    "<h2>El número " + NumeroIngresado +
    " y la letra " + LetraIngresada +
    ' coinciden.  <span style="color: green; font-weight: bold; font-family: Arial;">Ha ganado</span>.</h2>';
} else {
  document.getElementById("mensaje").innerHTML =
    "<h2>El número " + NumeroIngresado +
    " y la letra " + LetraIngresada +
    ' no coinciden.  <span style="color: red; font-weight: bold; font-family: Arial;">Ha perdido</span>.</h2>';
}


		
 	}
    	
 }
   
   